% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARCApplicationInput.R
\docType{data}
\name{ARCApplicationInput}
\alias{ARCApplicationInput}
\title{Abnormal Return Calculation Parameters}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
ARCApplicationInput
}
\value{
a ESTParameters R6 object
}
\description{
This R6 class defines the parameters for the Return Event Study. We recommend
to use the \code{set} functionality to setup your Event Study, as we check
input parameters.

For more details see the help vignette:
\code{vignette("parameters_eventstudy", package = "EventStudy")}
}
\section{Methods}{

\describe{
  \item{\code{$new()}}{Constructor for ARCApplicationInput.}
  \item{\code{$setEMail(eMail)}}{Set the e-Mail address for reporting. This 
  functionality is currently not working.}
  \item{\code{$setBenchmarkModel(model = 'mm')}}{Setter for the benchmark
  model.s}
  \item{\code{$setReturnType(returnType)}}{Setter for the return type (log 
  or simple)}
  \item{\code{$setTestStatistics(testStatistics)}}{Setter for the test 
  statistics.}
}
}

\section{Arguments}{

\describe{
 \item{ESTARCParameters}{An \code{ARCApplicationInput} object}
 \item{eMail}{An E-Mail address in \code{String} format}
 \item{model}{A benchmark model in \code{String} format}
 \item{returnType}{A return type in \code{String} format}
 \item{testStatistics}{A \code{String} vector with test statistics.}
}
}

\examples{
\dontrun{
# get files for our S&P500 example; 3 files are written in the current 
# working directory
getSP500ExampleFiles()

# Generate a new parameter object
arcParams <- ARCApplicationInput$new()

# set test statistics
arcParams$setBenchmarkModel("garch")

# Setup API object
apiKey <- "{Your API key}"
estSetup <- EventStudyAPI$new()
estSetup$authentication(apiKey)

# Perform Event Study
estSetup$performEventStudy(estParams = arcParams, 
                           dataFiles = c("request_file" = "01_RequestFile.csv",
                                         "firm_data"    = "02_firmData.csv",
                                         "market_data"  = "03_marketData.csv"))

# Download task results and save them in the actiual working directory
estSetup$getTaskResults()
}

}
\seealso{
\url{https://www.eventstudytools.com/axc/upload}
}
\keyword{datasets}
