% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.evaluate.core.R
\name{ttest.evaluate.core}
\alias{ttest.evaluate.core}
\title{Student's t Test}
\usage{
ttest.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
\item{Trait}{The
  quantitative trait.} \item{EC_Min}{The minimum value of the trait in EC.}
  \item{EC_Max}{The maximum value of the trait in EC.} \item{EC_Mean}{The
  mean value of the trait in EC.} \item{EC_SE}{The standard error of the
  trait in EC.} \item{CS_Min}{The minimum value of the trait in CS.}
  \item{CS_Max}{The maximum value of the trait in CS.} \item{CS_Mean}{The
  mean value of the trait in CS.} \item{CS_SE}{The standard error of the
  trait in CS.} \item{ttest_pvalue}{The p value of the Student's t
  test for equality of means of EC and CS.} \item{ttest_significance}{The
  significance of the Student's t test for equality of means of EC
  and CS.}
}
\description{
Test difference between means of entire collection (EC) and core set (CS) for
quantitative traits by Student's t test
\insertCite{student_probable_1908}{EvaluateCore}.
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

ttest.evaluate.core(data = ec, names = "genotypes",
                    quantitative = quant, selected = core)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{t.test}}
}
