% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{climatch_vec}
\alias{climatch_vec}
\title{Euclidean climatch scores}
\usage{
climatch_vec(recipient, source, globvar)
}
\arguments{
\item{recipient}{A data.frame of climatic variables for the recipient region.}

\item{source}{A data.frame of climatic variables for the source region.}

\item{globvar}{A vector of the global variance of each climate variable, in the same order as the columns of source and recipient region data.frames.}
}
\value{
A vector of climatch scores corresponding to each grid cell within recipient region, i.e., each row in the recipient data.frame.
}
\description{
Vector of the climatch scores within the recipient region
}
\examples{
i <- as.data.frame(matrix(runif(n=180, min=1, max=20), nrow=60)) # Fake source climate data
j <- as.data.frame(matrix(runif(n=300, min=10, max=40), nrow=100)) # Fake recipient data
variance <- c(600, 800, 450) # Fake global variance

climatch_vec(recipient = j, source = i, globvar = variance)

}
\references{
Crombie, J., Brown, L., Lizzio, J., & Hood, G. (2008). "Climatch user manual"
}
