% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{Distributions}
\alias{Distributions}
\alias{LogNormal}
\alias{Gamma}
\alias{Normal}
\alias{Fixed}
\alias{NonParametric}
\title{Probability distributions}
\usage{
LogNormal(meanlog, sdlog, mean, sd, ...)

Gamma(shape, rate, scale, mean, sd, ...)

Normal(mean, sd, ...)

Fixed(value, ...)

NonParametric(pmf, ...)
}
\arguments{
\item{meanlog, sdlog}{mean and standard deviation of the distribution
    on the log scale with default values of \code{0} and \code{1} respectively.}

\item{mean, sd}{mean and standard deviation of the distribution}

\item{...}{arguments to define the limits of the distribution that will be
passed to \code{\link[=bound_dist]{bound_dist()}}}

\item{shape, scale}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{rate}{an alternative way to specify the scale.}

\item{value}{Value of the fixed (delta) distribution}

\item{pmf}{Probability mass of the given distribution; this is
passed as a zero-indexed numeric vector (i.e. the fist entry represents
the probability mass of zero). If not summing to one it will be normalised
to sum to one internally.}
}
\value{
A \code{dist_spec} representing a distribution of the given
specification.
}
\description{
Probability distributions

Generates a nonparametric distribution.
}
\details{
Probability distributions are ubiquitous in EpiNow2, usually representing
epidemiological delays (e.g., the generation time for delays between
becoming infecting and infecting others; or reporting delays)

They are generated using functions that have a name corresponding to the
probability distribution that is being used. They generated \code{dist_spec}
objects that are then passed to the models underlying EpiNow2.
All parameters can be given either as fixed values (a numeric value) or as
uncertain values (a \code{dist_sepc}). If given as uncertain values, currently
only normally distributed parameters (generated using \code{Normal()}) are
supported.

Each distribution has a representation in terms of "natural" parameters (the
ones used in stan) but can sometimes also be specified using other
parameters such as the mean or standard deviation of the distribution. If
not given as natural parameters then these will be calculated from the given
parameters. If they have uncertainty, this will be done by random sampling
from the given uncertainty and converting resulting parameters to their
natural representation.

Currently available distributions are lognormal, gamma, normal, fixed
(delta) and nonparametric. The nonparametric is a special case where the
probability mass function is given directly as a numeric vector.
}
\examples{
LogNormal(mean = 4, sd = 1)
LogNormal(mean = 4, sd = 1, max = 10)
# If specifying uncertain parameters, use the natural parameters
LogNormal(meanlog = Normal(1.5, 0.5), sdlog = 0.25, max = 10)
Gamma(mean = 4, sd = 1)
Gamma(shape = 16, rate = 4)
Gamma(shape = Normal(16, 2), rate = Normal(4, 1))
Normal(mean = 4, sd = 1)
Normal(mean = 4, sd = 1, max = 10)
Fixed(value = 3)
Fixed(value = 3.5)
NonParametric(c(0.1, 0.3, 0.2, 0.4))
NonParametric(c(0.1, 0.3, 0.2, 0.1, 0.1))
}
