% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.accessor.R
\name{unique_id-tools}
\alias{unique_id-tools}
\alias{get_unique_ids}
\alias{get_posit_ids}
\title{Convert Unique Identifiers to/from Positional Identifiers}
\usage{
get_unique_ids(dat, posit_ids = NULL)

get_posit_ids(dat, unique_ids = NULL)
}
\arguments{
\item{dat}{Main list object containing a \code{networkDynamic} object and
other initialization information passed from \code{\link{netsim}}.}

\item{posit_ids}{A vector of node positional identifiers (default = NULL).}

\item{unique_ids}{A vector of node unique identifiers (default = NULL).}
}
\value{
A vector of unique or positional identifiers.
}
\description{
EpiModel refers to its nodes either by positional identifiers
             (\code{posit_ids}), which describe the position of a node in the
             \code{attr} vector, or by unique identifiers
             (\code{unique_ids}), which allow references to nodes even after
             they are deactivated.
}
\section{All elements}{

  When \code{unique_ids} or \code{posit_ids} is NULL (default)
  the full list of positional IDs or unique IDs is returned.
}

\section{Deactivated nodes}{

  When providing \code{unique_ids} of deactivated nodes to
  \code{get_posit_ids}, \code{NA}s are returned instead and a warning is
  produced.
}

