% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{brewer_ramp}
\alias{brewer_ramp}
\title{RColorBrewer Color Ramp for EpiModel Plots}
\usage{
brewer_ramp(n, plt, delete.lights = TRUE)
}
\arguments{
\item{n}{Number of colors to return.}

\item{plt}{\code{RColorBrewer} palette from \code{\link{brewer.pal}}.}

\item{delete.lights}{If TRUE, delete the lightest colors from the color
palette; this helps with plotting in many high-contrast palettes.}
}
\value{
A vector of length equal to \code{n} with a range of color values consistent
with an RColorBrewer color palette.
}
\description{
Returns a vector of colors consistent with a high-brightness set
             of colors from an \code{RColorBrewer} palette.
}
\details{
\code{RColorBrewer} provides easy access to helpful color palettes, but the
built-in palettes are limited to the set of colors in the existing palette.
This function expands the palette size to any number of colors by filling
in the gaps. Also, colors within the "div" and "seq" set of palettes whose
colors are very light (close to white) are deleted by default for better
visualization of plots.
}
\examples{
# Shows a 100-color ramp for 4 RColorBrewer palettes
par(mfrow = c(2, 2), mar=c(1, 1, 2, 1))
pals <- c("Spectral", "Greys", "Blues", "Set1")
for (i in seq_along(pals)) {
 plot(1:100, 1:100, type = "n", axes = FALSE, main = pals[i])
 abline(v = 1:100, lwd = 6, col = brewer_ramp(100, pals[i]))
}

}
\seealso{
\code{\link{RColorBrewer}}
}
\keyword{colorUtils}
\keyword{internal}
