% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.utils.R
\name{edgelist_meanage}
\alias{edgelist_meanage}
\title{Mean Age of Partnerships over Time}
\usage{
edgelist_meanage(x, el)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{\link{netest}}.}

\item{el}{If not passing \code{x}, a timed edgelist from a \code{networkDynamic}
object extracted with the \code{as.data.frame.networkDynamic} function.}
}
\description{
Outputs a vector of mean ages of edges at a series of timesteps
}
\details{
This function calculates the mean partnership age at each time step over
a dynamic network simulation from \code{\link{netest}}. These objects
contain the network, edgelist, and dissolution objects needed for the
calculation. Alternatively, one may pass in these objects separately if
\code{netest} was not used, or statistics were not run requested after
the estimation.

Currently, the calculations are limited to those dissolution formulas with a single
homogenous dissolution (\code{~offset(edges)}). This functionality will be
expanded in future releases.
}
\examples{
# Initialize and parameterize the network model
nw <- network.initialize(n = 100, directed = FALSE)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)

# Model estimation
est <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

# Simulate the network and extract a timed edgelist
sim <- netdx(est, nsims = 1, nsteps = 100, verbose = FALSE)
el <- sim$edgelist[[1]]

# Calculate ages directly from edgelist
( ma <- edgelist_meanage(el = el) )

# Alternatively, netdx calculates these
sim$pages
identical(sim$pages[[1]], ma)

}
\keyword{internal}
\keyword{netUtils}

