\name{htest.object}
\alias{htest.object}
\docType{class}
\title{
  S3 Class "htest"
}
\description{
  This class of objects is returned by functions that perform hypothesis tests 
  (e.g., the \R function \code{\link{t.test}}, the \pkg{EnvStats} function 
  \code{\link{kendallSeasonalTrendTest}}, etc.).   
  Objects of class \code{"htest"} are lists that contain information about the null 
  and alternative hypotheses, the estimated distribution parameters, the test statistic, 
  the p-value, and (optionally) confidence intervals for distribution parameters.
}
\details{
  Objects of S3 class \code{"htest"} are returned by any of the 
  \pkg{EnvStats} functions that perform hypothesis tests as listed 
  here: \link{Hypothesis Tests}.  

  (Note that functions that perform \link[=FcnsByCatGOFTests]{goodness-of-fit tests} 
  return objects of class \code{"gof"} or \cr
  \code{"gofTwoSample"}.)

  Objects of class \code{"htest"} generated by \pkg{EnvStats} functions may 
  contain additional components called 
  \code{estimation.method} (method used to estimate the population parameter(s)), 
  \code{sample.size}, and 
  \code{bad.obs} (number of missing (\code{NA}), undefined (\code{NaN}), or infinite 
  (\code{Inf}, \code{-Inf}) values removed prior to performing the hypothesis test), 
  and \code{interval} (a list with information about a confidence, prediction, or 
  tolerance interval). 
}
\section{Methods}{
  Generic functions that have methods for objects of class 
  \code{"htest"} include: \cr
  \code{\link{print}}.
}
\value{
  \strong{Required Components} \cr
  The following components must be included in a legitimate list of 
  class \code{"htest"}.

  \item{null.value}{
  numeric vector containing the value(s) of the population parameter(s) specified by 
  the null hypothesis.  This vector has a \code{names} attribute describing its 
  elements.
}
  \item{alternative}{
  character string indicating the alternative hypothesis (the value of the input 
  argument \code{alternative}).  Possible values are \code{"greater"}, \code{"less"}, 
  or \code{"two-sided"}.
}
  \item{method}{
  character string giving the name of the test used.
} 
  \item{estimate}{
  numeric vector containing the value(s) of the estimated population parameter(s) 
  involved in the null hypothesis.  This vector has a \code{names} attribute 
  describing its element(s).
}
  \item{data.name}{
  character string containing the actual name(s) of the input data.
}
  \item{statistic}{
  numeric scalar containing the value of the test statistic, with a 
  \code{names} attribute indicating the null distribution.
}
  \item{parameters}{
  numeric vector containing the parameter(s) associated with the null distribution of 
  the test statistic.  This vector has a \code{names} attribute describing its 
  element(s).
}
  \item{p.value}{
  numeric scalar containing the p-value for the test under the null hypothesis.
} 

  \strong{Optional Components} \cr
  The following component may optionally be included in an object of 
  of class \code{"htest"} generated by \R functions that test hypotheses:

  \item{conf.int}{
  numeric vector of length 2 containing lower and upper confidence limits for the 
  estimated population parameter.  This vector has an attribute called 
  \code{"conf.level"} that is a numeric scalar indicating the confidence level 
  associated with the confidence interval.
} 

  The following components may be included in objects of class \code{"htest"} 
  generated by \pkg{EnvStats} functions:

  \item{sample.size}{
  numeric scalar containing the number of non-missing observations in the sample used 
  for the hypothesis test.
}
  \item{estimation.method}{
  character string containing the method used to compute the estimated distribution 
  parameter(s).  The value of this component will depend on the available estimation 
  methods (see \code{\link{Distribution.df}}).
}
  \item{bad.obs}{
  the number of missing (\code{NA}), undefined (\code{NaN}) and/or infinite 
  (\code{Inf}, \code{-Inf}) values that were removed from the data object prior to 
  performing the hypothesis test.
}
  \item{interval}{
  a list containing information about a confidence, prediction, or tolerance interval.
}
}
\note{
  Since objects of class \code{"htest"} are lists, you may extract 
  their components with the \code{$} and \code{[[} operators.
}
\author{
  Steven P. Millard (\email{EnvStats@ProbStatInfo.com})
}
\seealso{
  \code{\link{print.htest}}, \link{Hypothesis Tests}.
}
\examples{
  # Create an object of class "htest", then print it out. 
  #------------------------------------------------------

  htest.obj <- chenTTest(EPA.02d.Ex.9.mg.per.L.vec, mu = 30)

  mode(htest.obj) 
  #[1] "list" 

  class(htest.obj) 
  #[1] "htest" 

  names(htest.obj) 
  # [1] "statistic"   "parameters"  "p.value"     "estimate"   
  # [5] "null.value"  "alternative" "method"      "sample.size"
  # [9] "data.name"   "bad.obs"     "interval" 
 
  htest.obj 
  
  #Results of Hypothesis Test
  #--------------------------
  #
  #Null Hypothesis:                 mean = 30
  #
  #Alternative Hypothesis:          True mean is greater than 30
  #
  #Test Name:                       One-sample t-Test
  #                                 Modified for
  #                                 Positively-Skewed Distributions
  #                                 (Chen, 1995)
  #
  #Estimated Parameter(s):          mean = 34.566667
  #                                 sd   = 27.330598
  #                                 skew =  2.365778
  #
  #Data:                            EPA.02d.Ex.9.mg.per.L.vec
  #
  #Sample Size:                     60
  #
  #Test Statistic:                  t = 1.574075
  #
  #Test Statistic Parameter:        df = 59
  #
  #P-values:                        z               = 0.05773508
  #                                 t               = 0.06040889
  #                                 Avg. of z and t = 0.05907199
  #
  #Confidence Interval for:         mean
  #
  #Confidence Interval Method:      Based on z
  #
  #Confidence Interval Type:        Lower
  #
  #Confidence Level:                95%
  #
  #Confidence Interval:             LCL = 29.82
  #                                 UCL =   Inf

  #==========

  # Extract the test statistic
  #---------------------------

  htest.obj$statistic
  #       t 
  #1.574075

  #==========

  # Clean up
  #---------
  rm(htest.obj)
}
\keyword{classes}
