% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmpiricalCalibrationUsingMcmc.R
\name{fitMcmcNull}
\alias{fitMcmcNull}
\title{Fit the null distribution using MCMC}
\usage{
fitMcmcNull(logRr, seLogRr, iter = 1e+05)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the standard
error = (log(<lower bound 95 percent confidence interval>) - log(<effect
estimate>))/qnorm(0.025)}

\item{iter}{Number of iterations of the MCMC.}
}
\value{
An object of type \code{mcmcNull} containing the mean and standard deviation (both on the log
scale) of the null distribution, as well as the MCMC trace.
}
\description{
\code{fitNull} fits the null distribution to a set of negative controls using Markov Chain Monte
Carlo (MCMC).
}
\details{
This is an experimental function for computing the 95 percent credible interval of a calibrated
p-value using Markov-Chain Monte Carlo (MCMC).
}
\examples{
\dontrun{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
null <- fitMcmcNull(negatives$logRr, negatives$seLogRr)
null
plotMcmcTrace(null)
positive <- sccs[sccs$groundTruth == 1, ]
calibrateP(null, positive$logRr, positive$seLogRr)
}
}
