% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUNC__Schwefel.R
\name{schwefel_func}
\alias{schwefel_func}
\title{Schwefel Function}
\usage{
schwefel_func(x)
}
\arguments{
\item{x}{numeric or complex vector.}
}
\value{
The value of the function.
}
\description{
\loadmathjax
Implementation of n-dimensional Schwefel function.
}
\details{
On an n-dimensional domain it is defined by

\mjdeqn{f(\vec{x}) = \sum_{i=1}^{n} \left[ -x_{i}\sin(\sqrt{|x_{i}|}) \right],}{f(x) = sum_1^n [ -x_i*sin(sqrt(|x_i|) ],}
and is usually evaluated on
\mjeqn{x_{i} \in [ -500, 500 ]}{x_{i} in [-500, 500]}, for all
\mjeqn{i=1,...,n}{i=1,...,n}. The function has one global minimum at
\mjeqn{f(\vec{x}) = -418.9829n}{f(x) = -418.9829n} for \mjeqn{x_{i}=420.9687}{x_i=420.9687} for all \mjeqn{i=1,...,n}{i=1,...,n}.
}
\references{
\insertRef{Schwefel1981}{EmiR}
}
