% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_elo.R
\name{scale_elo}
\alias{scale_elo}
\alias{scale.elo}
\title{standardize Elo ratings}
\usage{
scale_elo(x)
}
\arguments{
\item{x}{numeric, a vector of Elo ratings}
}
\value{
a numeric vector of Elo ratings, which are scaled between 0 and 1, with the highest rating that is supplied becoming 1, the lowest becoming 0, and all others being proportionally scaled in between
}
\description{
standardize Elo ratings between 0 and 1
}
\examples{
data(adv)
SEQ <- elo.seq(winner=adv$winner, loser=adv$loser, Date=adv$Date)
extract_elo(SEQ, "2010-01-30")
extract_elo(SEQ, "2010-01-30", standardize=TRUE)

# same as
scale_elo(extract_elo(SEQ, "2010-01-30"))
}
\author{
Christof Neumann
}
