% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e.single.R
\name{e.single}
\alias{e.single}
\title{Elo ratings for a single interaction}
\usage{
e.single(ELO1old, ELO2old, outcome, k = 100, normprob = TRUE)
}
\arguments{
\item{ELO1old, ELO2old}{numeric, Elo rating of the first and second individual}

\item{outcome}{\code{1} = first individual wins and second looses\cr
\code{2} = second individual wins and first looses\cr
\code{0} = interaction ends in a draw/tie (no winner and no looser)}

\item{k}{numeric, \emph{k} factor, by default \code{k = 100}}

\item{normprob}{logical (by default \code{TRUE}). Should a normal curve be assumed for calculating the winning/losing probablities, or a logistic curve. See \code{\link{winprob}} for details}
}
\value{
integer vector of length 2 with updated ratings of first and second individual after the interaction
}
\description{
calculate/update Elo ratings for a single dyadic interaction
}
\examples{
e.single(ELO1old = 1200, ELO2old = 1000, outcome = 1, k = 100)
# same as before
e.single(ELO1old = 1000, ELO2old = 1200, outcome = 2, k = 100)
# an undecided interaction
e.single(ELO1old = 1200, ELO2old = 1000, outcome = 0, k = 100)
# if rating differences are too big, no change occurs
# if higher-rated individual wins
e.single(ELO1old = 2000, ELO2old = 1000, outcome = 1, k = 100)
# same as before but lower-rated individual wins and
# therefore wins maximum number of points possible (i.e. k)
e.single(ELO1old = 2000, ELO2old = 1000, outcome = 2, k = 100)

}
\references{
\insertRef{elo1978}{EloRating}

\insertRef{albers2001}{EloRating}
}
\author{
Christof Neumann
}
