% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_pinverse}
\alias{Eigen_pinverse}
\title{Pseudo-inverse of a matrix}
\usage{
Eigen_pinverse(M)
}
\arguments{
\item{M}{a matrix, real or complex, not necessarily square}
}
\value{
The pseudo-inverse matrix of \code{M}.
}
\description{
Pseudo-inverse of a real or complex matrix 
  (Moore-Penrose generalized inverse).
}
\examples{
library(EigenR)
M <- rbind(
  toeplitz(c(3, 2, 1)), 
  toeplitz(c(4, 5, 6))
)
Mplus <- Eigen_pinverse(M)
all.equal(M, M \%*\% Mplus \%*\% M)
all.equal(Mplus, Mplus \%*\% M \%*\% Mplus)
#' a complex matrix
A <- M + 1i * M[, c(3L, 2L, 1L)]
Aplus <- Eigen_pinverse(A)
AAplus <- A \%*\% Aplus
all.equal(AAplus, t(Conj(AAplus))) #' `A \%*\% Aplus` is Hermitian
AplusA <- Aplus \%*\% A
all.equal(AplusA, t(Conj(AplusA))) #' `Aplus \%*\% A` is Hermitian
}
