% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.plot.function.R
\name{coords.plot}
\alias{coords.plot}
\title{Spatial Data Coordinate Plot}
\usage{
coords.plot(data)
}
\arguments{
\item{data}{A data frame or matrix containing
the x-coordinates in meters in the first column,
the y-coordinates in meters in the second column,
and the values of the attribute of interest in the third column.
Additional columns are ignored.}
}
\value{
The function returns a plot showing the points based on Cartesian coordinates. A black circle indicates that the
        variable of interest is observed at that location and a red cross flags a missing value.
}
\description{
Plot of the Cartesian coordinates of study participant with color and shape coded
indication whether the variable of interest is observed at a specific location.
}
\examples{
## Example 1
xcoords = rnorm(10, mean = 0, sd = 20)
ycoords = rnorm(10, mean = 0, sd = 20)
value = c(22, 31, 10, NA, NA, 18, 9, NA, 1, 34)
dataset = cbind(xcoords, ycoords, value)
coords.plot(dataset)

## Example 2
coords.plot(birth)

}
