% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff.ini.seceig.general.R
\name{eff.ini.seceig.general}
\alias{eff.ini.seceig.general}
\title{General conservative matrix maximal eigenpair}
\usage{
eff.ini.seceig.general(Q, z0 = NULL, c1 = 1000, digit.thresh = 6)
}
\arguments{
\item{Q}{The input general matrix.}

\item{z0}{The type of initial \eqn{z_0} used to calculate the approximation of \eqn{\rho(Q)}.
There are two types: 'fixed' and 'Auto' corresponding to two choices
of \eqn{z_0} in paper.}

\item{c1}{A large constant.}

\item{digit.thresh}{The precise level of output results.}
}
\value{
A list of eigenpair object are returned, with components \eqn{z}, \eqn{v} and \eqn{iter}.
\item{z}{The approximating sequence of the maximal eigenvalue.}
\item{v}{The approximating sequence of the corresponding eigenvector.}
\item{iter}{The number of iterations.}
}
\description{
Calculate the next to maximal eigenpair for the general conservative matrix.
}
\note{
The conservativity of matrix \eqn{Q=(q_{ij})} means that the sums of each row of
matrix \eqn{Q} are all 0.
}
\examples{
Q = matrix(c(-30, 1/5, 11/28, 55/3291, 30, -17, 275/42, 330/1097,
0, 84/5, -20, 588/1097, 0, 0, 1097/84, -2809/3291), 4, 4)
eff.ini.seceig.general(Q, z0 = 'Auto', digit.thresh = 5)
eff.ini.seceig.general(Q, z0 = 'fixed', digit.thresh = 5)
}
\seealso{
\code{\link{eff.ini.seceig.tri}} for the tridiagonal matrix next to the maximal eigenpair.
}
