% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{species_combo}
\alias{species_combo}
\title{SpeciesCombo Co-occurrence Metric}
\usage{
species_combo(m = matrix(rbinom(100, 1, 0.5), nrow = 10))
}
\arguments{
\item{m}{a binary presence-absence matrix in which rows are species and columns
are sites.}
}
\value{
Returns the number of unique species combinations represented by
the different columns (= sites) in the matrix.
}
\description{
Function to calculate number of unique species combinations in a matrix
}
\details{
In Diamond's (1975) assembly rules model, species interactions lead to
certain "forbidden combinations" of species. A set of communities structured
this way should contain fewer species combinations than expected by chance.
}
\note{
This metric is most useful when the number of sites (= columns) is relatively
large compared to the number of species (= rows). Empty sites are excluded
from the matrix and are not counted as a unique species combination.
}
\examples{
obsCombo <- species_combo(m=matrix(rbinom(100,1,0.5),nrow=10))
}
\references{
Diamond, J.M. 1975. Assembly of species communities. p. 342-444 in:
Ecology and Evolutoin of Communities. M.L. Cody and J.M. Diamond (eds.).
Harvard University Press, Cambridge.

Pielou, D.P. and E.C. Pielou. 1968. Association among species of infrequent
occurrence: the insect and spider fauna of Polyporus betulinus (Bulliard) Fries.
Journal of Theoretical Biology 21: 202-216.
}

