% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.weight.R
\name{eco.weight}
\alias{eco.weight}
\title{Spatial weights}
\usage{
eco.weight(XY, method = c("circle", "knearest", "inverse", "circle.inverse",
  "exponential", "circle.exponential"), d1 = 0, d2 = NULL, k = NULL,
  p = 1, alpha = 1, dist.method = "euclidean", row.sd = FALSE,
  self = FALSE, latlon = FALSE)
}
\arguments{
\item{XY}{Matrix/data frame with projected coordinates.}

\item{method}{Method of spatial weight matrix: "circle", "knearest", "inverse",
"circle.inverse", "exponential", "circle.exponential".}

\item{d1}{Minimum distance for circle matrices.}

\item{d2}{Maximum distance for circle matrices.}

\item{k}{Number of neighbors for nearest neighbor distance. When equidistant
neighbors are present, the program select them randomly.}

\item{p}{Power for inverse distance. Default = 1.}

\item{alpha}{Alpha value for exponential distance. Default = 1.}

\item{dist.method}{Method of computing distance when XY is in metric
units. If latlon is TRUE, the method is euclidean.}

\item{row.sd}{Logical. Should be row standardized the matrix? Default FALSE
(binary weights).}

\item{self}{Should be the individuals self-included in circle or knearest
weights? Defalut FALSE.}

\item{latlon}{Are the coordinates in decimal degrees format? Defalut FALSE. If TRUE,
the coordinates must be in a matrix/data frame with the longitude in the first
column and latitude in the second. The position is projected onto a plane in
meters with the function \code{\link[SoDA]{geoXY}}.}
}
\value{
An object of class eco.weight with the following slots:

@W weights matrix

@XY input coordinates

@METHOD weights construction method

@PAR parameters used for the construction of weights

@PAR.VAL values of the parameters used for the construction of weights

@ROW.SD row standardization (logical)

@SELF data self-included (logical)

@NONZERO percentage of non-zero connections

@NONZEROIND percentage of individuals
with non-zero connections

@AVERAGE average number of connection per individual
}
\description{
Spatial weights for individuals with coordinates XY
}
\details{
This program computes a weights matrix (square matrix with individuals
in rows and columns, and weights wij in cells (i and j, individuals))
under the following available methodologies:

- circle: all the connection between individuals i and j, included
in a distance radius, higher than d1 and lower than d2, with center in
the individual i, have a value of 1 for binary weights.
This distance requires the parameters d1 and d2 (default d1 = 0).

- knearest: the connections between an individual and its
nearest neighbors of each individual i have a value of 1  for binary weights.
This distance requires the parameter k.

- inverse: inverse distance with exponent p (distance = 1/dij^p, with
dij the distance between individuals i and j).
This distance requires the parameter p (default p = 1).

- circle inverse: combination of "circle" and "inverse".
 It is the matrix obtained by multiplying each element in a "circle"
 binary matrix, and an "inverse" matrix.
 This distance requires the parameters p, d1 and d2 (default p = 1, d1 = 0).

 - exponential: inverse exponential distance with parameter alpha
  (distance = 1/e^(alpha *dij), with dij the distance between individuals i and j).
  This distance requires the parameter alpha (default alpha = 1).

- circle exponential: combination of "circle" and "exponential".
 It is the matrix obtained by multiplying each element in a "circle"
 binary matrix, and an "exponential" matrix.
 This distance requires the parameters alpha, d1 and d2 (default alpha = 1, d1 = 0).

 In row standardization, each weight wij for the individual i, is divided by the
 sum of the row weights (i.e., wij / sum(wij), where sum(wij) is computed over an
 individual i and all individuals j).

 When self is TRUE, the connection j = i is also included.
}
\examples{
\dontrun{

data(eco.test)

# "circle" method
con <- eco.weight(eco$XY, method = "circle", d1 = 0, d2 = 2)
con

# "knearest" method
con <- eco.weight(eco$XY, method = "knearest", k=3)
con

# "inverse" method
con <- eco.weight(eco$XY, method = "inverse")
con

# "circle.inverse" method
con <- eco.weight(eco$XY, method = "circle.inverse")
con

# "exponential" method
con <- eco.weight(eco$XY, method = "exponential")
con

# "circle.exponential" method
con <- eco.weight(eco$XY, method = "circle.exponential", d2 = 2)
con
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

