% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/int.ecogen.definition.R
\name{ecogen}
\alias{ecogen}
\title{Creating a new ecogen object.}
\usage{
ecogen(XY = data.frame(), P = data.frame(), G = data.frame(),
  E = data.frame(), S = data.frame(), C = data.frame(), missing = c("0",
  "NA", "MEAN"), ploidy = 2, ...)
}
\arguments{
\item{XY}{Data frame with m columns (coordinates) and n rows (individuals).}

\item{P}{Data frame with n rows (individuals), and phenotypic data in columns.}

\item{G}{Data of class:

- "data.frame", with n rows (individuals), and genotypic data in columns
(loci), in a format accepted by the adegenet \code{\link[adegenet]{df2genind}} function.


- "DNAbin", converted to genind via \code{\link[adegenet]{DNAbin2genind}}


- "allignment", converted to genind via \code{\link[adegenet]{alignment2genind}}}

\item{E}{Data frame with n rows (individuals), and environmental data
in columns.}

\item{S}{Data frame with n rows (individuals), and groups (factors) in columns.
The program converts non factor data into factor.}

\item{C}{data frame with n rows (individuals), and custom variables in columns.}

\item{missing}{Missing data treatment ("0", "NA", or "MEAN") for the GENIND
@tab slot (see details in \code{\link[adegenet]{df2genind}}).
Missing elements are set to 0 in the default option.}

\item{ploidy}{Ploidy of the G data frame. Default ploidy = 2.}

\item{...}{Further arguments passed to \code{\link[adegenet]{df2genind}}
when G data is of class "data.frame", otherwise are passed to
\code{\link[adegenet]{DNAbin2genind}} when G data is of class "DNAbin" or to
\code{\link[adegenet]{alignment2genind}} when G data is of class "alignment".}
}
\description{
Creating a new ecogen object.
}
\details{
This is a generic function for creating an ecogen object. The non
genetic data must be of class "data.frame". For the genetic data, there are
three options: Data of "data.frame" class (for example, microsatellite,
AFLP, RAPD, etc.); data of "DNAbin" class (ape data); and data of
"allignment" class (seqinr data). The program is able to recognize
the classes and differentiate between codominant and presence-absence
(binary) data.
Cells in data frames with missing data must be filled with the value 0.
}
\examples{
\dontrun{

#Example with G data of class "data.frame", corresponding to
#microsatellites of a diploid organism:
data(eco.test)
eco <- ecogen(XY = coordinates, P = phenotype, G = genotype,
E = environment, S = as.data.frame(structure))

summary(eco)              # mean and standard deviation of the P variables, and
                          # genetic summary via adegenet

summary(eco, "pop")       # P summary by factor "pop"

save_summary <- summary(eco, "pop")
save_summary$P_mean
save_summary$P_sd
save_summary$P_mean.and.sd
save_summary$G_summary

#Example with G data of class "data.frame", corresponding to a
#presence - absence molecular marker:
dat <- sample(c(0,1),100,rep = TRUE)
dat <- data.frame(matrix(dat,10,10))
eco <- ecogen(G = dat)

#Example with G data of class "DNAbin":
require(ape)
data(woodmouse)
G <- woodmouse
eco <- ecogen( G = G)

#Example with G data of class "alignment":
require(seqinr)
data(mase)
G <- mase
eco <- ecogen( G = G)

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
\code{\link[adegenet]{df2genind}}
}

