% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.NDVI.post.R
\name{eco.NDVI.post}
\alias{eco.NDVI.post}
\title{Postprocessing for NDVI and MSAVI 2 temporal series of Landsat 5 and 7}
\usage{
eco.NDVI.post(tab, correct = c("COST", "DOS"), method = c("NDVI", "MSAVI2"),
  datatype = c("FLT4S", "FLT8S", "INT4U", "INT4S", "INT2U", "INT2S", "INT1U",
  "INT1S", "LOG1S"), what = c("mean", "max", "min", "var", "none"))
}
\arguments{
\item{tab}{Table used with \code{\link{eco.NDVI}}.}

\item{correct}{Correction method used in \code{\link{eco.NDVI}}.}

\item{method}{the vegetation index used in \code{\link{eco.NDVI}}.}

\item{datatype}{type of data, see \code{\link[raster]{dataType}}.
Default "FLT4S".}

\item{what}{Functions to apply over the created stack.
The values permitted are: "none", "max", "min", "mean" and "var".
The functions are implemented with \code{\link[raster]{calc}}.
If more that one function would be applied, must be used the following
syntax: c("fun1", "fun2", "funi"),}
}
\description{
This program must be used sequentially after \code{\link{eco.NDVI}}.
The inputs required (tab, correct, method) are the same described
and used in that function. The algorithm stacks the images and save
the stack into the working directory with the name "time.tif".
If the user wishes, the program can also compute images of max, min,
mean and var by pixel over the temporal sequence. Default is "mean".
}
\examples{
\dontrun{

require(raster)

data(eco.test)
temp <- list()

# we create 4 simulated rasters for the data included in the object tab:

for(i in 1:4) {
temp[[i]] <- runif(19800, 0, 254)
temp[[i]] <- matrix(temp[[i]], 180, 110)
temp[[i]] <- raster(temp[[i]])
extent(temp[[i]]) <- c(3770000, 3950000,6810000, 6920000)
}


writeRaster(temp[[1]], "20040719b4.tif", overwrite = T)
writeRaster(temp[[2]], "20040719b3.tif", overwrite = T)
writeRaster(temp[[3]], "20091106b4.tif", overwrite = T)
writeRaster(temp[[4]], "20091106b3.tif", overwrite = T)

# Computing NDVI images:

eco.NDVI(tab, "COST", "NDVI", "LT5")

# Mean NDVI image computed over the NDVI images that we calculated:

eco.NDVI.post(tab, "COST", "NDVI", what = c("mean", "var"))
mean.ndvi <- raster("NDVI.COST.mean.tif")
plot(mean.ndvi)

# Extraction of the mean NDVI for each point in the object eco and plot
of the data:

ndvi <- extract(mean.ndvi, eco$XY)
ndvi<-eco.rescale(ndvi)
plot(eco$XY[, 1], eco$XY[, 2], col=rgb(ndvi, 0, 0),
pch=15, main = "Mean NDVI", xlab = "X", ylab  = "Y")

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
eco.NDVI

extract
}

