% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fundescribe.R
\name{fundescribe}
\alias{fundescribe}
\title{A Convenient Way of Descriptive Statistics}
\usage{
fundescribe(x, y, data = NULL, na.rm = TRUE, norm.t = NULL)
}
\arguments{
\item{x}{The variable to be statistically described.}

\item{y}{An optional variable need to be a factor, or a character, or a logical vector.}

\item{data}{An optional parameter, the name of the data containing x and y.}

\item{na.rm}{An optional parameter, if FALSE, the information of NA will be given.}

\item{norm.t}{An optional parameter, there are seven normal test methods available: c("ks.test", "shapiro.test", "cvm.test", "lillie.test", "pearson.test", "sf.test", "ad.test").}
}
\value{
No return value, called for side effects.
}
\description{
This function can perform descriptive statistics according to different data types.
}
\details{
This function can perform descriptive statistics according to different data types. If the data is a continuous variable, the mean and standard deviation or median and quartile are automatically output; if the data is a categorical variable, the number and percentage are automatically output. In addition, if you enter two variables, the first variable will be described hierarchically based on the second variable and the statistical differences between different groups will be compared using appropriate statistical methods. And for groups more than two, the post hoc test will be applied.
}
\examples{
data(T2D)
fundescribe(T2D$age, norm.t = c("lillie.test"))
fundescribe(gender, data = T2D)
fundescribe(education, diabetes, data = T2D)
fundescribe(T2D$glucose, T2D$diabetes)
}
\references{
Libiseller, C. and Grimvall, A. (2002) Performance of partial Mann-Kendall tests for trend detection in the presence of covariates.
\emph{Environmetrics}, 13, 71-84. \doi{doi:10.1002/env.507}.

Patefield, W. M. (1981) An efficient method of generating r x c tables with given row and column totals.
\emph{Applied Statistics}, 30, 91-97. \doi{doi:10.2307/2346669}

Hope, A. C. A. (1968) A simplified Monte Carlo significance test procedure.
\emph{Journal of the Royal Statistical Society Series B}, 30, 582-598. \doi{doi:10.1111/J.2517-6161.1968.TB00759.X}

Mehta, C. R. and Patel, N. R. (1983) A network algorithm for performing Fisher's exact test in r x c contingency tables.
\emph{Journal of the American Statistical Association}, 78, 427-434. \doi{doi:10.1080/01621459.1983.10477989}

Mehta, C. R. and Patel, N. R. (1986) Algorithm 643: FEXACT, a FORTRAN subroutine for Fisher's exact test on unordered r x c contingency tables.
\emph{ACM Transactions on Mathematical Software}, 12, 154-161. \doi{doi:10.1145/6497.214326}

Clarkson, D. B., Fan, Y. and Joe, H. (1993) A Remark on Algorithm 643: FEXACT: An Algorithm for Performing Fisher's Exact Test in r x c Contingency Tables.
\emph{ACM Transactions on Mathematical Software}, 19, 484-488. \doi{doi:10.1145/168173.168412}

Cochran, W. G. (1954) Some methods for strengthening the common chi-squared tests.
\emph{International Biometric Society}, 10 (4), 417-451. \doi{doi:10.2307/3001616}

Armitage, P. (1955) Tests for Linear Trends in Proportions and Frequencies.
\emph{International Biometric Society}, 11 (3), 375-386. \doi{doi:10.2307/3001775}

Szabo, A. (2016) Test for trend with a multinomial outcome.
\emph{American Statistician}, 73 (4), 313-320. \doi{doi:10.1080/00031305.2017.1407823}

David, F. B. (1972) Constructing confidence sets using rank statistics.
\emph{Journal of the American Statistical Association}, 67, 687-690. \doi{doi:10.1080/01621459.1972.10481279}

Joanes, D. N. and Gill, C. A. (1998) Comparing measures of sample skewness and kurtosis.
\emph{The Statistician}, 47, 183-189. \doi{doi:10.1111/1467-9884.00122}

Dunn, O. J. (1964) Multiple comparisons using rank sums.
\emph{Technometrics}, 6, 241-252. \doi{doi:10.1080/00401706.1964.10490181}

Copenhaver, M. D. and Holland, B. S. (1988) Computation of the distribution of the maximum studentized range statistic with application to multiple significance testing of simple effects.
\emph{Journal of Statistical Computation and Simulation}, 30, 1-15. \doi{doi:10.1080/00949658808811082}

Chambers, J. M., Freeny, A. and Heiberger, R. M. (1992) \emph{Statistical Models in S.}
49-52. \doi{doi:10.1201/9780203738535-5}

Shaffer, J. P. (1995) Multiple hypothesis testing.
\emph{Annual Review of Psychology}, 46, 561-584. \doi{doi:10.1146/annurev.ps.46.020195.003021}

Myles, H. and Douglas, A. W. (1973) \emph{Nonparametric Statistical Methods.}
115-120. \doi{doi:10.2307/2063815}

Rahman, M. and Tiwari, R. (2012) Pairwise comparisons in the analysis of carcinogenicity data.
\emph{Health}, 4, 910-918. \doi{doi:10.4236/health.2012.410139}

Thode, H. J. (2002) \emph{Testing for Normality.} \doi{10.1201/9780203910894}
}
\author{
Xiuquan Nie, niexiuquan1995@foxmail.com
}
