% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRN.R
\name{predict.QRN_seq}
\alias{predict.QRN_seq}
\title{Predict method for a QRN_seq fitted object}
\usage{
\method{predict}{QRN_seq}(object, ...)
}
\arguments{
\item{object}{Fitted \code{"QRN_seq"} object.}

\item{...}{
  Arguments passed on to \code{\link[=QRN_seq_predict]{QRN_seq_predict}}
  \describe{
    \item{\code{X}}{Matrix of covariates to predict the corresponding response's conditional quantiles.}
    \item{\code{Y}}{Response variable vector corresponding to the rows of \code{X}.}
    \item{\code{q_level}}{Optional, checks that \code{q_level == fit_qrn_ts$interm_lvl}.}
    \item{\code{crop_predictions}}{Whether to crop out the fist \code{seq_len} observations (which are \code{NA}) from the returned matrix.}
    \item{\code{device}}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
  }}
}
\value{
Matrix of size \code{nrow(X)} times \code{1}
(or \code{nrow(X)-seq_len} times \code{1} if \code{crop_predictions})
containing the conditional quantile estimates of the corresponding response observations.
}
\description{
Predict method for a QRN_seq fitted object
}
\details{
See \code{\link[=QRN_seq_predict]{QRN_seq_predict()}} for more details.
}
