% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSS.R
\name{coef.EMSS}
\alias{coef.EMSS}
\title{Getting Coefficients of EM type Sample Selection Model Fits}
\usage{
\method{coef}{EMSS}(object, only = NULL, ...)
}
\arguments{
\item{object}{an object of class "EMSS" made by the function \code{EMSS}.}

\item{only}{a character value for choosing specific variable's coefficients. Initial value is \code{NULL},
which shows all variable's coefficients. If "response" is written, only coefficients for response variables
will be returned, and if "selection" is written, only coefficients for selection variables will be returned.}

\item{...}{not used, but exists because of the compatibility.}
}
\value{
a numeric vector or a list, containing one set or two sets, is given.
}
\description{
\code{coef} method for a class "EMSS".
}
\examples{
# examples continued from EMSS
data(Smoke, package = "EMSS")
ex1 <- EMSS(response = cigs_intervals ~ educ,
           selection = smoker ~ educ + age,
           data = Smoke)
coef(ex1)

data(Smoke, package = "EMSS")
ex2 <- EMSS(response = cigs_intervals ~ educ,
           selection =  smoker ~ educ + age,
           data = Smoke, method="ECMnr")
coef(ex2)

## example using random numbers with exclusion restriction

N <- 1000
errps <- mvtnorm::rmvnorm(N,c(0,0),matrix(c(1,0.5,0.5,1),2,2) )
xs <- runif(N)
ys <- xs+errps[,1]>0
xo <- runif(N)
yo <- (xo+errps[,2])*(ys>0)

ex3 <- EMSS(response = yo ~ xo,
           selection = ys ~ xs,
           initial.param = c(rep(0,4), 0.3, 0.6), method="ECMnr")
coef(ex3)

}
