% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eml_validate.R
\name{eml_validate}
\alias{eml_validate}
\title{eml_validate}
\usage{
eml_validate(eml, encoding = "UTF-8", schema = NULL)
}
\arguments{
\item{eml}{file path, xml_document,}

\item{encoding}{optional encoding for files, default UTF-8.}

\item{schema}{path to schema}

\item{...}{additional arguments to eml_write, such as namespaces}
}
\value{
Whether the document is valid (logical)
}
\description{
eml_validate processes an EML document using the XSD schema for the
appropriate version of EML and determines if the document is schema-valid
as defined by the XSD specification
}
\note{
this function is simply an alias to `eml_validate` in `emld` package
}
\examples{
\donttest{

f <- system.file("extdata", "example.xml", package = "emld")

## validate file directly from disk:
eml_validate(f)

## validate an eml object:
eml <- read_eml(f)
eml_validate(eml)
}

}
