% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{posterior_summary.emc}
\alias{posterior_summary.emc}
\alias{posterior_summary}
\title{Posterior quantiles}
\usage{
\method{posterior_summary}{emc}(
  emc,
  selection = "mu",
  probs = c(0.025, 0.5, 0.975),
  digits = 3,
  ...
)

posterior_summary(emc, ...)
}
\arguments{
\item{emc}{An emc object}

\item{selection}{A Character vector. Indicates which parameter types to check (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{probs}{A vector. Indicates which quantiles to return from the posterior.}

\item{digits}{Integer. How many digits to round the output to}

\item{...}{Optional additional arguments that can be passed to \code{get_pars}}
}
\value{
A list of posterior quantiles for each parameter group in the selected parameter type.
}
\description{
Returns the quantiles of the selected parameter type.
Full range of possible samples manipulations described in \code{get_pars}.
}
\examples{
posterior_summary(samples_LNR)
}
