% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supporting_functions.R
\name{gee.generator}
\alias{gee.generator}
\title{Generate longitudinal data without missingness}
\usage{
gee.generator(beta,samplesize,time,num.time.dep,num.time.indep,
     rho,x.rho,dist,cor.str,x.cor.str)
}
\arguments{
\item{beta}{A vector containing underlying true coefficients for each covariate in the model (including the intercept).}

\item{samplesize}{The sample size.}

\item{time}{The number of observations per subject.}

\item{num.time.dep}{The number of time-dependent covariates.}

\item{num.time.indep}{The number of time-independent covariates (not include intercept).}

\item{rho}{The correlation coefficient for residuals across time.}

\item{x.rho}{The correlation coefficient for time-dependent covariates across time.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}

\item{cor.str}{The correlation structure for residuals across time. It can be "independence","exchangeable", and "ar1".}

\item{x.cor.str}{The correlation structure for time-dependent covariates across time. It can be "independence","exchangeable", and "ar1".}
}
\value{
x: a matrix containing continuous covariates. The first column should contain all ones corresponding to the intercept.

y: a vector containing outcomes.

id: a vector indicating subject id.
}
\description{
A function for generating longitudinal data without missingness. All covariates (except for intercept) are normally distributed.
}
\examples{
beta<-c(-1,1,0.5,0)
samplesize<-100
geesimdata<-gee.generator(beta=beta,samplesize=samplesize,time=3,num.time.dep=2,
num.time.indep=1,rho=0.4,x.rho=0.2,dist="poisson",cor.str="exchangeable",
x.cor.str="exchangeable")
geesimdata$y

}
