% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseMedExtractR.R
\name{parseMedExtractR}
\alias{parseMedExtractR}
\title{Parse medExtractR NLP Output}
\usage{
parseMedExtractR(filename)
}
\arguments{
\item{filename}{File name for a single file containing medExtractR output.}
}
\value{
A data.table object with columns for filename, drugname, strength, dose, route,
freq, dosestr, dosechange and lastdose. The filename contains the file name
corresponding to the clinical note. Each of the entity columns are of the format
"extracted expression::start position::stop position".
}
\description{
Takes files with the raw medication extraction output generated by the medExtractR
natural language processing system and converts it into a standardized format.
}
\details{
Output from different medication extraction systems is formatted in different ways.
In order to be able to process the extracted information, we first need to convert
the output from different systems into a standardized format. Extracted expressions
for various drug entities (e.g., drug name, strength, frequency, etc.) each receive
their own column formatted as "extracted expression::start position::stop position".
If multiple expressions are extracted for the same entity, they will be separated by
backticks.

The medExtractR system returns extractions in a long table format, indicating the
entity, extracted expression, and start:stop position of the extraction. To perform
this initial parsing, entities are paired with the closest preceding drug name. The
one exception to this is the dose change entity, which can occur before the drug name
(see Weeks, et al. 2020 for details).
}
\examples{
mxr_output <- system.file("examples", "lam_mxr.csv", package = "EHR")
mxr_parsed <- parseMedExtractR(mxr_output)
mxr_parsed
}
