% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wBTCode.R
\name{saveEGRETci}
\alias{saveEGRETci}
\title{Save EGRETci workspace after wBT}
\usage{
saveEGRETci(eList, eBoot, caseSetUp, fileName = "")
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{eBoot}{named list. Returned from \code{\link{wBT}}.}

\item{caseSetUp}{data frame. Returned from \code{\link{trendSetUp}}.}

\item{fileName}{character. If left blank (empty quotes), the function will interactively ask for a name to save.}
}
\description{
Saves critical information in a EGRETci workflow when analyzing trends over a set of two years.
}
\examples{
library(EGRET)
eList <- Choptank_eList
\dontrun{
caseSetUp <- trendSetUp(eList)
eBoot <- wBT(eList,caseSetUp)
saveEGRETci(eList, eBoot, caseSetUp)
}
}
\seealso{
\code{\link{wBT}}, \code{\link{trendSetUp}}, \code{\link[EGRET]{modelEstimation}}
}

