% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.loads.R
\name{net.loads}
\alias{net.loads}
\title{Network Loadings}
\usage{
net.loads(A, wc, rm.zero = FALSE, plot = FALSE)
}
\arguments{
\item{A}{Matrix, data frame, or \code{\link[EGAnet]{EGA}} object. 
An adjacency matrix of network data}

\item{wc}{Numeric. 
A vector of community assignments.
Not necessary if an \code{\link[EGAnet]{EGA}} object
is input for argument \code{A}}

\item{rm.zero}{Should zeros be removed from the resulting matrix?
Defaults to \code{FALSE}.
Set to \code{TRUE} to reduce the noise in the results}

\item{plot}{Boolean.
Should proportional loadings be plotted?
Defaults to \code{FALSE}.
Set to \code{TRUE} for plot with pie charts
visualizing the proportion of loading associated with
each dimension}
}
\value{
Returns a list containing:

\item{unstd}{A matrix of the unstandardized within- and between-community
strength values for each node}

\item{std}{A matrix of the standardized within- and between-community
strength values for each node}
}
\description{
Computes the between- and within-community
\code{\link[NetworkToolbox]{strength}} of each item
for each community. This function uses the
\code{\link[NetworkToolbox]{comcat}} and
\code{\link[NetworkToolbox]{stable}} functions to calculate
the between- and within-community strength of each item, respectively.
}
\details{
Simulation studies have demonstrated that a node's strength
centrality is roughly equivalent to factor loadings
(Christensen, Golino, & Silvia, 2019; Hallquist, Wright, & Molenaar, in press).
Hallquist and colleagues (in press) found that node strength represented a
combination of dominant and cross-factor loadings. This function computes
each node's strength within each specified dimension, providing a rough
equivalent to factor loadings (including cross-loadings).

For more details, type \code{vignette("Network_Scores")}
}
\examples{

# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Estimate EGA
ega.wmt <- EGA(wmt)

}

# Network loadings
net.loads(ega.wmt, rm.zero = TRUE)

}
\references{
Christensen, A. P., Golino, H. F., & Silvia, P. (2019).
A psychometric network perspective on the measurement and assessment of personality traits.
\emph{PsyArXiv}.
doi:\href{https://doi.org/10.31234/osf.io/ktejp}{10.31234/osf.io/ktejp} 

Hallquist, M., Wright, A. C. G., & Molenaar, P. C. (in press).
Problems with centrality measures in psychopathology symptom networks: Why network psychometrics cannot escape psychometric theory.
\emph{Multivariate Behavioral Research}.
doi:\href{https://doi.org/10.31234/osf.io/pg4mf}{10.31234/osf.io/pg4mf}
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com> and Hudson F. Golino <hfg9s at virginia.edu>
}
