% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cutEEM.R
\name{cutEEM}
\alias{cutEEM}
\alias{cutEEM.EEM}
\alias{cutEEM.EEMweight}
\title{Cut portions of EEM}
\usage{
cutEEM(x, cutEX = NULL, cutEM = NULL)

\method{cutEEM}{EEM}(x, cutEX = NULL, cutEM = NULL)

\method{cutEEM}{EEMweight}(x, cutEX = NULL, cutEM = NULL)
}
\arguments{
\item{x}{a list of EEM data generated by \code{\link{readEEM}} function or
EEMweight object generated by \code{\link{extract}}-related functions.}

\item{cutEX}{Numeric or sequential data specifying regions to be cut for excitation wavelength.
Examples, 200 or 200:500 or c(200:300, 600:800)}

\item{cutEM}{Numeric or sequential data specifying regions to be cut for emission wavelength.
Examples, 200 or 200:500 or c(200:300, 600:800)}
}
\value{
A list similar to input \code{EEM} is returned but with specified portions cut.
}
\description{
Cut portions of EEM
}
\examples{
data(applejuice)
drawEEM(cutEEM(applejuice, cutEX = 200:250), 1)
}

