modified_schwefel <- function(x) {
  D <- length(x)
  z <- x + 420.9687462275036
  m <- abs(z) %% 500

  term1 <- 418.9829 * D
  term2 <- sum(ifelse(abs(z) <= 500,
                      z * sin(sqrt(abs(z))),
                      ifelse(z > 500,
                             (500 - m) * sin(sqrt(500 - m)) - (z - 500)^2 / (10000 * D),
                             (m - 500) * sin(sqrt(m - 500)) - (z + 500)^2 / (10000 * D))))

  return(term1 - term2)
}
