% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute_event_subscription.R
\name{execute_event_subscription}
\alias{execute_event_subscription}
\title{Execute event subscription}
\usage{
execute_event_subscription(subscriptionId, env = "production")
}
\arguments{
\item{subscriptionId}{(numeric) Event subscription identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(logical) TRUE if the event subscription was executed
}
\description{
Execute event subscription
}
\details{
Upon notification, the event manager queries its database for the
subscription matching the specified subscriptionId. POST requests are then
made (asynchronously) to the matching subscription.
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Create subscription
subscriptionId <- create_event_subscription(
  packageId = "knb-lter-vcr.340.1",
  url = "https://my.webserver.org/",
  env = "staging"
)
subscriptionId
#> [1] 48

# Execute subscription
execute_event_subscription(
  subscriptionId = subscriptionId,
  env = "staging"
)
#> [1] TRUE

# Delete subscription
delete_event_subscription(subscriptionId, env = "staging")
#> [1] TRUE

logout()
}

}
\seealso{
Other Event Notifications: 
\code{\link{create_event_subscription}()},
\code{\link{delete_event_subscription}()},
\code{\link{get_event_subscription_schema}()},
\code{\link{get_event_subscription}()},
\code{\link{query_event_subscriptions}()}
}
\concept{Event Notifications}
