% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{main}
\alias{main}
\title{Main function of the MCMC simulation.}
\usage{
main(X, Y, initiation, GLOBvar, HYPERvar)
}
\arguments{
\item{X}{Input response data.}

\item{Y}{Input target data.}

\item{initiation}{Initialisation of the MCMC simulation, as obtained by
function \code{\link{init}}.}

\item{GLOBvar}{Global variables of the MCMC simulation.}

\item{HYPERvar}{Hyperparameter variables.}
}
\value{
Returns a list with the following elements: \item{counters}{List
containing the different move counters for the number of times moves have
been proposed and accepted.} \item{listStock}{List containing the recorded
samples for the networks, changepoints and hyperparameters}
}
\description{
This function executes the main loop of the MCMC simulation, making the
different moves and recording samples.
}
\author{
Sophie Lebre

Frank Dondelinger
}
\references{
For more information about the MCMC simulations, see:

Dondelinger et al. (2012), "Non-homogeneous dynamic Bayesian networks with
Bayesian regularization for inferring gene regulatory networks with
gradually time-varying structure", Machine Learning.
}
\seealso{
\code{\link{runDBN}}
}

