% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{find_keyword}
\alias{find_keyword}
\title{Find a keyword in the whole database}
\usage{
find_keyword(keyword, data = edc_lookup(), ignore_case = TRUE)
}
\arguments{
\item{keyword}{the keyword to search for. Can handle regular expressions (see examples).}

\item{data}{the lookup dataframe where to search the keyword. Can be set using \code{edc_options(edc_lookup=my_data)}, which is done automatically when calling \code{\link[=read_trialmaster]{read_trialmaster()}}.}

\item{ignore_case}{should case differences be ignored in the match? Default to \code{TRUE}.}
}
\value{
a tibble
}
\description{
Find a keyword in all names and labels of a list of datasets.
}
\examples{
\dontrun{
path = system.file("extdata/Example_Export_SAS_XPORT_2022_08_25_15_16.zip", 
                   package="EDCimport", mustWork=TRUE)
w = read_trialmaster(path, verbose=FALSE)

find_keyword("patient")

#with regex
find_keyword("patient$")
find_keyword("\\\\d")
find_keyword("(Trial|Form) Name")
find_keyword("\\\\(") #you need to escape special characters
}
}
