% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialmaster.R
\name{read_trialmaster}
\alias{read_trialmaster}
\title{Read the \code{.zip} archive of a TrialMaster export}
\usage{
read_trialmaster(
  archive,
  ...,
  use_cache = TRUE,
  clean_names_fun = NULL,
  split_mixed = FALSE,
  extend_lookup = FALSE,
  key_columns = get_key_cols(),
  pw = getOption("trialmaster_pw"),
  verbose = getOption("edc_verbose", 1)
)
}
\arguments{
\item{archive}{[\code{character(1)}]\cr the path to the archive}

\item{...}{unused}

\item{use_cache}{[\code{logical(1)}: \sQuote{TRUE}]\cr if \code{TRUE}, read the \code{.rds} cache if any or extract the archive and create a cache. If \code{FALSE} extract the archive without creating a cache file.}

\item{clean_names_fun}{[\code{function}]\cr a function to clean column names, e.g. \code{\link[janitor:clean_names]{janitor::clean_names()}}}

\item{split_mixed}{[\code{logical(1): FALSE}]\cr whether to split mixed datasets. See \link{split_mixed_datasets}.}

\item{extend_lookup}{[\code{character(1): FALSE}]\cr whether to enrich the lookup table. See \link{extend_lookup}.}

\item{key_columns}{[\code{list}]\cr the result of \code{\link[=get_key_cols]{get_key_cols()}}, containing the column name used for patient ID and CRF name. Important for \code{split_mixed} and \code{extend_lookup}.}

\item{pw}{[\code{character(1)}]\cr The password if the archive is protected. To avoid writing passwords in plain text, it is probably better to use \code{options(trialmaster_pw="xxx")} instead though.}

\item{verbose}{[\code{logical(1)}]\cr one of \code{c(0, 1, 2)}. The higher, the more information will be printed.}
}
\value{
a list containing one dataframe for each \code{.xpt} file in the folder, the extraction date (\code{datetime_extraction}), and a summary of all imported tables (\code{.lookup}). If not set yet, option \code{edc_lookup} is automatically set to \code{.lookup}.
}
\description{
Import the \code{.zip} archive of a TrialMaster trial export as a list of dataframes. The archive filename should be leaved untouched as it contains the project name and the date of extraction. \cr
Generate a \code{.rds} cache file for future reads. \cr
If \verb{7zip} is not installed or available, use \code{\link[=read_tm_all_xpt]{read_tm_all_xpt()}} instead.
}
