% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estND.R
\name{estND}
\alias{estND}
\title{Estimate nondecision denstiy}
\usage{
estND(res, tt = NULL, data = NULL, h = res$h, zp = 5, upper.bound = 1,
  lower.bound = 0, Optim = list(), verbose = TRUE, dist = NULL, NDindex,
  max = 100)
}
\arguments{
\item{res}{an object of class \code{D*M}.}

\item{tt}{optional timegrid if the nondecision density is to be esimtated at a different grid than the model density.}

\item{data}{if \code{tt} is specified then the original dataset must be supplied too.}

\item{h}{Optional smoothing parameter to be used when estimating the nondecision model on a
different time grid than the decision model. If omitted, the smoothing parameter of the decision model
is used.}

\item{zp}{Zero padding the estimated nondecision density by this amount to avoid numerical artefacts.}

\item{upper.bound}{An upper bound for the nondecision density. Defaults to one.
Lowering this bound can increase estimation speed,
at the cost of assuming that the density of the nondecision distribution is zero past this value.}

\item{lower.bound}{A lower bound for the nondecision density. Defaults to zero.
Increasing this bound can increase estimation speed,
at the cost of assuming that the density of the nondecision distribution is zero past this value.}

\item{Optim}{a named list with identical arguments to \code{\link{DEoptim.control}}.
In addition, if \code{verbose} == TRUE \code{Optim$steptol} can be a vector, i.e. \code{c(200, 50, 10)} means:
Do 200 iterations then check for convergence, do 50 iterations then check for convergence,
check every 10 iterations for convergence until itermax is reached.
If there are multiple nondecision distributions to estimate, one can supply different estimation
parameters for every nondecision distribution by supplying Optim as a list of lists. Every sublists
then corresponds to parameters for one nondecision distribution and should consist of arguments for
\code{\link{DEoptim.control}}.
Defaults to \code{Optim = list(reltol = 1e-6, itermax = 1e4, steptol = 200, CR = .9, trace = 0)}.}

\item{verbose}{Logical, should the function return text output on the current status of the estimation procedure.
As the estimation can take 30+ minutes this defaults to yes.
If FALSE, the analysis will be somewhat faster.}

\item{dist}{A matrix where columns represent nondecision distributions.
If this argument is supplied then the objective function will be evaluated in these values.}

\item{NDindex}{A vector containing indices of which nondecision distributions to estimate.
If omitted, all nondecision distributions that complement the results in \code{res} are estimated.}

\item{max}{A positive float which indicates the maximum height of the nondecision distribution.
If estimated nondecision distributions appear chopped of or have a lot of values at this \code{max}
value it is recommended to re-estimate the nondecision distributions with a higher max value. Increasing
the \code{max} value without reason will increase the size of the parameter space and slow the estimation
procedure.}
}
\description{
Estimate nondecision denstiy
}
\examples{
# simulate data with three stimuli of different difficulty.
# this implies different drift rates across conditions.
# define a time grid. A more reasonable stepsize is .01; this is just for speed.
tt = seq(0, 5, .1)
pars = c(.8, 2, .5, .5, .5, # condition 1
        .8, 3, .5, .5, .5, # condition 2
        .8, 4, .5, .5, .5) # condition 3
pdfND = dbeta(tt, 10, 30)
# simulate data
dat = simData(n = 3e5, pars = pars, tt = tt, pdfND = pdfND)
# define restriction matrix
restr = matrix(1:5, 5, 3)
restr[2, 2:3] = 6:7 # allow drift rates to differ
# fix variance parameters
fixed = matrix(c('sz1', .5, 'sv1', .5), 2, 2)
\dontrun{
# Run D*M analysis
res = estDstarM(data = dat, tt = tt, restr = restr, fixed = fixed)
# Estimate nondecision density
resND = estND(res)
plot(resND)
lines(tt, pdfND, type = 'b', col = 2)
}
}
