% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require.R
\name{requireObservationBeforeDrug}
\alias{requireObservationBeforeDrug}
\title{Restrict cohort to only cohort records with the given amount of prior
observation time in the database}
\usage{
requireObservationBeforeDrug(
  cohort,
  days,
  cohortId = NULL,
  name = omopgenerics::tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{days}{Number of days of prior observation required before cohort start
date. Any records with fewer days will be dropped.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{name}{Name of the new cohort table, it must be a length 1 character
vector.}
}
\value{
The cohort table having applied the prior observation requirement.
}
\description{
Filter the cohort table keeping only the cohort records for which the
individual has the required observation time in the database prior to their
cohort start date.
}
\examples{
\donttest{
cdm <- mockDrugUtilisation()

cdm$cohort1 <- cdm$cohort1 |>
  requireObservationBeforeDrug(days = 365)

attrition(cdm$cohort1) |>
  dplyr::glimpse()
}

}
