% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDrugUtilisation.R
\name{addInitialDailyDose}
\alias{addInitialDailyDose}
\title{To add a new column with the initial daily dose. To add multiple columns use
\code{addDrugUtilisation()} for efficiency.}
\usage{
addInitialDailyDose(
  cohort,
  ingredientConceptId,
  conceptSet = NULL,
  indexDate = "cohort_start_date",
  censorDate = "cohort_end_date",
  restrictIncident = TRUE,
  nameStyle = "initial_daily_dose_{concept_name}_{ingredient}",
  name = NULL
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{ingredientConceptId}{Ingredient OMOP concept that we are interested for
the study.}

\item{conceptSet}{List of concepts to be included.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{restrictIncident}{Whether to include only incident prescriptions in the
analysis. If FALSE all prescriptions that overlap with the study period will
be included.}

\item{nameStyle}{Character string to specify the nameStyle of the new columns.}

\item{name}{Name of the new computed cohort table, if NULL a temporary table
will be created.}
}
\value{
The same cohort with the added column.
}
\description{
To add a new column with the initial daily dose. To add multiple columns use
\code{addDrugUtilisation()} for efficiency.
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

cdm$cohort1 |>
  addInitialDailyDose(ingredientConceptId = 1125315)
}

}
