% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.R
\name{drbats.simul}
\alias{drbats.simul}
\title{Main simulation function}
\usage{
drbats.simul(
  N = 10,
  P = 150,
  t.range = c(0, 1000),
  b.range = c(0.2, 0.4),
  c.range = c(0.6, 0.8),
  b.sd = 2,
  c.sd = 2,
  a.range = c(-0.4, 0.4),
  y.range = c(0, 10),
  amp = 10,
  per = 12,
  data.type = "sparse",
  breaks = 15,
  sigma2 = 0.2,
  seed = NULL
)
}
\arguments{
\item{N}{integer number of functions to simulate (default = 10)}

\item{P}{a number of observation times (default = 150)}

\item{t.range}{a range of times in which to place the P observations (default = c(1, 1000))}

\item{b.range}{a vector giving the range of values for the mean of the first mode (default b.range = c(0.2, 0.4))}

\item{c.range}{a vector giving the range of values for the mean of the second mode (default c.range = c(0.6, 0.8))}

\item{b.sd}{the standard deviation for the first mode (default b.sd = 2)}

\item{c.sd}{the standard deviation for the second mode (default c.sd = 2)}

\item{a.range}{a vector giving the range of values for the slope (default a.range = c(-0.4, 0.4))}

\item{y.range}{a vector giving the range of values for the intercept (default y.range = c(0, 10))}

\item{amp}{the amplitude of the cosine function (default = 10)}

\item{per}{the periodicity of the cosine function (default = 12)}

\item{data.type}{string indicating type of functions (options :sparse, sparse.tend, sparse.tend.cos)}

\item{breaks}{number of breaks in the histogram basis}

\item{sigma2}{the precision of the error terms (default = 0.2)}

\item{seed}{integer specification of a seed (default = NULL)}
}
\value{
Y.simul a list containing a matrix Y, a matrix beta, and a matrix epsilon

t.simul a matrix of simulated observation times

X the underlying signal to build the data, see DataSimulationandProjection vignette

proj.pca the outputs of the function pca.proj.Xt

wlu the outputs of the function W.QR
}
\description{
Main simulation function
}
\examples{
res <- drbats.simul(N = 5, P = 100, t.range = c(5, 100), breaks = 8)
X <- res$X
t <- res$t.simul
# To plot the observations, ie the rows
matplot(t(t), t(X), type = 'l', xlab = "Time", ylab = "X")

}
\author{
Gabrielle Weinrott
}
