% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.R
\name{W.QR}
\alias{W.QR}
\title{Build and decompose a low-rank matrix W}
\usage{
W.QR(U, lambda)
}
\arguments{
\item{U}{a matrix of eigenvectors}

\item{lambda}{a vector of corresponding eigenvalues}
}
\value{
W a low-rank matrix

D the number of latent factors

Q the orthogonal matrix of the W = QR matrix decomposition

R the upper triangular matrix of the W = QR matrix decomposition
}
\description{
Build and decompose a low-rank matrix from
a matrix of eigenvectors and eigenvalues
from principal component analysis
}
\examples{
res <- drbats.simul(N = 5, P = 100, t.range = c(5, 100), breaks = 8)
res.pca <- pca.Deville(res$X, res$t.simul, t.range = c(5, 100), breaks = 8)
Wres.pca <- W.QR(res.pca$U, res.pca$lambda)
Wres.pca

}
\author{
Gabrielle Weinrott
}
