% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{postdens}
\alias{postdens}
\title{Calculate the unnormalized posterior density of the model}
\usage{
postdens(mcmc.output, Y, D, chain = 1)
}
\arguments{
\item{mcmc.output}{an mcmc list as produced by clean.mcmc}

\item{Y}{the data matrix}

\item{D}{the number of latent factors}

\item{chain}{the chain to plot (default = 1)}
}
\value{
post a vector containing the posterior density at each iteration##' @examples
}
\description{
Calculate the unnormalized posterior density of the model
}
\examples{
require(DrBats)
data("toydata")
data("stanfit")
codafit <- coda.obj(stanfit)
Y <- toydata$Y.simul$Y
N = nrow(Y)
D = toydata$wlu$D
P = ncol(Y)
## PCA in the histogram basis
obs <- toydata$X
times <- toydata$t
pca.data <- pca.Deville(obs, times, t.range = c(min(times), max(times)), breaks = 15)
## Post-processing landmark information
rotation <- toydata$wlu$Q # rotation matrix
real.W <- toydata$wlu$W # PCA-determined latent factors
real.B <- t(pca.data$Cp[, 1:(toydata$wlu$D)]) # PCA-determined scores
mcmc.output <- clean.mcmc(N, P, D, codafit, rotation, real.W, real.B)
post <- postdens(mcmc.output, Y, D, chain = 1)

## plot the density
hist(post)

}
\author{
Gabrielle Weinrott
}

