% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/JarqueBeraBacktest.R
\name{JarqueBeraBacktest}
\alias{JarqueBeraBacktest}
\title{Jarque-Bera backtest for normality.}
\usage{
JarqueBeraBacktest(sample.skewness, sample.kurtosis, n)
}
\arguments{
\item{sample.skewness}{Coefficient of Skewness of the sample}

\item{sample.kurtosis}{Coefficient of Kurtosis of the sample}

\item{n}{Number of observations}
}
\value{
Probability of null hypothesis H0
}
\description{
Jarque-Bera (JB) is a backtest to test whether the skewness and kurtosis of a
given sample matches that of normal distribution. JB test statistic is
defined as \deqn{JB=\frac{n}{6}\left(s^2+\frac{(k-3)^2}{4}\right)} where
\eqn{n} is sample size, \eqn{s} and \eqn{k} are coefficients of sample
skewness and kurtosis.
}
\examples{
# JB test statistic for sample with 500 observations with sample
   # skewness and kurtosis of -0.075 and 2.888
   JarqueBeraBacktest(-0.075,2.888,500)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.

Jarque, C. M. and Bera, A. K. A test for normality of observations and
regression residuals, International Statistical Review, 55(2): 163-172.
}

