\name{Class design and accessors}
\alias{[.design}
\alias{design}
\alias{desnum}
\alias{run.order}
\alias{design.info}
\alias{factor.names}
\alias{response.names}
\alias{ord}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Class design and its accessor functions }
\description{
  Convenience functions to quickly access attributes of data frames of the class 
  design that have been generated by functions FrF2, pb or fac.design
}
\usage{
desnum(design)
run.order(design)
design.info(design)
factor.names(design)
response.names(design)
design
\method{[}{design}(x, i, j, drop.attr = TRUE, drop = FALSE)
ord(matrix, decreasing=FALSE)
}
\arguments{
  \item{design}{ data frame of S3 class \code{design}. For the structures of design 
       objects, refer to the details section and to the value sections of the 
       functions that create them. }
  \item{x}{ data frame of S3 class \code{design}, like argument \code{design} }
  \item{i}{ indices for subsetting rows }
  \item{j}{ indices for subsetting columns }
  \item{drop.attr}{ logical, controls whether or not attributes are dropped; 
       if TRUE, the result is no longer of class \code{design}, and all special design attributes are dropped;
       otherwise, the design attributes are adjusted to reflect the subsetting result}
  \item{drop}{ logical that controls dropping of dimensions in the Extract function for 
       data.frame objects, which is called by the method for class design}
  \item{matrix}{matrix, data frame or also object of class design that is to be ordered column by column}
  \item{decreasing}{logical, indicates whether decreasing order or not (increasing is default)}
}
\details{
    Items of class \code{design} are data frames with attributes. They are generated 
    by various functions that create experimental designs, currently by 
    \code{FrF2}, \code{pb}, \code{\link{oa.design}} \code{\link{fac.design}}, 
    by the above extractor function for class \code{design}, and by \code{\link{fix.design}}.
    
    The data frame itself always contains the design in uncoded form (for all currently 
    implemented design generation functions, these are factors; for future functions for 
    quantitative factors, this may be different). 
    Generally, its attributes are \code{desnum}, 
    \code{run.order}, and \code{design.info}. Attribute \code{desnum} contains 
    a numeric coded version of the design, attribute \code{run.order} a data frame 
    with run order information (standard order, randomized order, order with replication info), 
    and the details of \code{design.info} partly depend on the type of design. 
    
    \code{design.info} generally is a list with first element \code{type}, 
    further info on the design, 
    and some options of the design call regarding randomization and replication. 
    For all design types, elements include 
    \describe{
    \item{nruns}{number of runs (not adjusted for replications)}
    \item{nfactors}{number of factors}
    \item{factor.names}{named list, as can be handed to function \code{\link{oa.design}}}
    \item{replications}{the integer number of replications (1=unreplicated)} 
    \item{repeat.only}{logical indicating whether replications are only repeat runs but not 
         truly replicated}
    \item{randomized}{logical indicating whether the experiment was randomized} 
    \item{seed}{the integer seed handed to the function call by the user}
    \item{response.names}{in the presence of response data only; 
        the character vector identifying response columns in the data frame} 
    \item{creator}{contains the call or 
    (in the future) the list of menu settings within the currently developed 
    package \pkg{RcmdrPlugin.DoE} that led to creation of the design.}
    }
    
    For some design types, notably designs of types starting with \dQuote{FrF2}, 
    there can be substantial additional information available from the \code{design.info} 
    attribute in specialized situations. Detailed information on the structure of \code{design.info} 
    can be found in the value sections of the respective functions.
    
    
    The functions \code{desnum}, \code{run.order} and \code{design.info} extract 
    the respective attribute, i.e. e.g. function design.info 
    extracts the design information for the design. The functions \code{factor.names} 
    and \code{response.names} extract the respective elements of the \code{design.info} 
    attribute.
    
    The extractor method subsets the design, taking care of the attributes accordingly.
}
\value{
    \item{desnum}{returns a numeric matrix,}
    \item{run.order}{returns a 3-column data frame with standard and actual run order 
         as well as a run order with replication identifiers attached,}
    \item{design.info}{returns the design.info attribute of the design}
    \item{}{The extractor function returns a class design object with modified attributes 
        or a data frame without special attributes, depending on the situation. 
        
        If \code{j} is given, the function always returns a data frame without 
        special attributes, even if \code{drop.attr=FALSE} or \code{j=1:ncol(design)}.\cr
        If only \code{i} is given, 
        the default option \code{drop.attr=TRUE} also returns a 
        data frame without attributes.\cr
        Exception: Even for \code{drop.attr=TRUE}, if \code{i} is a permutation of 
        the row numbers or a logical vector with all elements TRUE, 
        the attributes are preserved, and attributes \code{run.order} 
        and \code{desnum} are reordered along with the design, if necessary.\cr
        If \code{drop.attr=FALSE} and \code{j} is empty, 
        the function returns an object of class design with rows of attributes \code{run.order} 
        and \code{desnum} selected in line with those of the design itself. 
        In this case, the new \code{design.info} attribute is a list with entries 
        \itemize{
        \item{type}{resolving to \dQuote{subset of design}, }
        \item{subset.rows}{ a numeric or logical vector with the selected rows, and}
        \item{orig.design.info}{ which contains the original design.info attribute.}
        }}
    \item{ord}{returns an index vector that orders the matrix or data frame; 
        for example, \code{design[ord(design),]} orders the design in increasing order with respect to the first,
        then the second etc. factor.}
}
\author{ Ulrike Groemping }
\note{ The package is currently subject to intensive development; most key functionality is now included. 
Some changes to input and output structures may still occur.}
\seealso{ ~~See Also \code{FrF2}, \code{pb}, \code{\link{fac.design}} }
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ array }
\keyword{ design }% __ONLY ONE__ keyword per line
