% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Disequilibrium.R
\name{nLLikelihoodDE}
\alias{nLLikelihoodDE}
\title{Negative log likelihood of market in disequilibrium model}
\usage{
nLLikelihoodDE(...)
}
\arguments{
\item{...}{arguements to be passed to LLikelhoodDE}
}
\description{
A wrapper function that makes the output of LLikelihoodDE negative.
See ?LLikelihoodDE for details.
}
\examples{
set.seed(1775)
library(MASS)
beta01 = c(1,1)
beta02 = c(-1,-1)
N = 10000
SigmaEps = diag(2)
SigmaX = diag(2)
MuX = c(0,0)
par0 = c(beta01, beta02, SigmaX[1, 1], SigmaX[1, 2], SigmaX[2, 2])

Xgen = mvrnorm(N,MuX,SigmaX)
X1 = cbind(1,Xgen[,1])
X2 = cbind(1,Xgen[,2])
X = list(X1 = X1,X2 = X2)
eps = mvrnorm(N,c(0,0),SigmaEps)
eps1 = eps[,1]
eps2 = eps[,2]
Y1 = X1 \%*\% beta01 + eps1
Y2 = X2 \%*\% beta02 + eps2
Y = pmin(Y1,Y2)

p1 = 2
p2 = 2
theta = c(beta01, beta02, log(SigmaX[1, 1]), atanh(SigmaX[1, 2]), log(SigmaX[2, 2]))

lhood = nLLikelihoodDE(theta, Y, X, summed = TRUE)
head(nLLikelihoodDE)

}
