% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disaggregate.R
\name{disaggregate}
\alias{disaggregate}
\title{Temporal Disaggregation Methods}
\usage{
disaggregate(
  Y,
  X = matrix(data = rep(1, times = nrow(Y)), nrow = nrow(Y)),
  aggMat = "sum",
  aggRatio = 4,
  method = "Chow-Lin",
  Denton = "first"
)
}
\arguments{
\item{Y}{The low-frequency response series (n_l x 1 matrix).}

\item{X}{The high-frequency indicator series (n x p matrix).}

\item{aggMat}{Aggregation matrix according to 'first', 'sum', 'average', 'last' (default is 'sum').}

\item{aggRatio}{Aggregation ratio e.g. 4 for annual-to-quarterly, 3 for quarterly-to-monthly (default is 4).}

\item{method}{Disaggregation method using 'Denton', 'Denton-Cholette', 'Chow-Lin', 'Fernandez', 'Litterman', 'spTD' or 'adaptive-spTD' (default is 'Chow-Lin').}

\item{Denton}{Type of differencing for Denton method: 'absolute', 'first', 'second' and 'proportional' (default is 'first').}
}
\value{
y_Est	Estimated high-frequency response series (n x 1 matrix).

beta_Est	Estimated coefficient vector (p x 1 matrix).

rho_Est	Estimated residual AR(1) autocorrelation parameter.

ul_Est	Estimated aggregate residual series (n_l x 1 matrix).
}
\description{
This function contains the traditional standard-dimensional temporal disaggregation methods proposed by \insertCite{denton1971adjustment;textual}{DisaggregateTS}, \insertCite{dagum2006benchmarking;textual}{DisaggregateTS},
\insertCite{chow1971best;textual}{DisaggregateTS}, \insertCite{fernandez1981methodological;textual}{DisaggregateTS} and \insertCite{litterman1983random;textual}{DisaggregateTS},
and the high-dimensional methods of \insertCite{mosley2021sparse;textual}{DisaggregateTS}.
}
\details{
Takes in a n_l x 1 low-frequency series to be disaggregated Y and a n x p high-frequency matrix of p indicator series X. If n > n_l x aggRatio where aggRatio
is the aggregation ration (e.g. aggRatio = 4 if annual-to-quarterly disagg or aggRatio = 3 if quarterly-to-monthly disagg) then extrapolation is done
to extrapolate up to n.
}
\examples{
data = TempDisaggDGP(n_l=25,n=100,p=10,rho=0.5)
X = data$X_Gen
Y = data$Y_Gen
fit_chowlin = disaggregate(Y=Y,X=X,method='Chow-Lin')
y_hat = fit_chowlin$y_Est
}
\references{
\insertAllCited{}
}
\keyword{Chow-Lin}
\keyword{Denton}
\keyword{Denton-Cholette}
\keyword{Fernandez}
\keyword{Litterman}
\keyword{adaptive-spTD}
\keyword{lasso}
\keyword{spTD}
\keyword{temporal-disaggregation}
