## README
The `DisImpact` R package contains functions that help in determining Disproportionate Impact (DI) based on the following methodologies:

1. [Percentage Point Gap](https://www.cccco.edu/-/media/CCCCO-Website/About-Us/Divisions/Digital-Innovation-and-Infrastructure/Research/Files/PercentagePointGapMethod2017.ashx) (PPG) method,
2. [Proportionality Index](https://www.cccco.edu/-/media/CCCCO-Website/Files/DII/guidelines-for-measuring-disproportionate-impact-in-equity-plans-tfa-ada.pdf) method (method #1 in reference), and
3. [80% Index](https://www.cccco.edu/-/media/CCCCO-Website/Files/DII/guidelines-for-measuring-disproportionate-impact-in-equity-plans-tfa-ada.pdf) (method #2 in reference).

## Install Package
```{r}
# From CRAN
## install.packages('DisImpact')

# From github (Development)
## devtools::install_github('vinhdizzo/DisImpact')
```

## Tutorial
A vignette on how to use the package can be found [here](https://CRAN.R-project.org/package=DisImpact/vignettes/Tutorial.html).
