##' A metabolite data set. The Arabidopsis metabolome of the aerial
##' regions of individual WT plants and the mto1 and tt4 mutants
##' were analyzed by GC-TOF/MS. 
##'
##' 50 samples (WT, n = 17; mto1, n = 13; and tt4, n = 20, biological
##' replicates).
##' 
##' A matrix containing  59 metabolites (rows) and 50 observations 
##' (columns).
##'
##' MetaboLights accession no.: MTBLS40
##' 
##' For comparisons with data from roots (Fukushima et al. 2011) we selected 
##' 59 commonly-detected metabolites in both datasets using 
##' MetMask http://metmask.sourceforge.net.
##' 
##' @name AraMetLeaves
##' @docType data
##' @aliases AraMetLeaves
##' @title A metabolite data set from Arabidopsis leaves by GC-TOF/MS
##' 
##' @keywords datasets
##' @references Miyako Kusano, Atsushi Fukushima et al. BMC Syst Biol 2007 1:53
##' @author Atsushi Fukushima
NULL


##' A metabolite data set. The Arabidopsis metabolome of the roots 
##' of individual WT plants and the mto1 and tt4 mutants were
##' analyzed by GC-TOF/MS. 
##'
##' 53 root samples (WT, n = 17; mto1 n = 16; and tt4, n = 20,
##' biological replicates).
##' 
##' A matrix containing  59 metabolites (rows) and 53 observations 
##' (columns).
##'
##' MetaboLights accession no.: MTBLS45
##' 
##' For comparisons with data from aerial parts (Kusano, Fukushima et al. 2007) 
##' we selected 59 commonly-detected metabolites in both datasets using 
##' MetMask http://metmask.sourceforge.net.
##' 
##' @name AraMetRoots
##' @docType data
##' @aliases AraMetRoots
##' @title A metabolite data set from Arabidopsis roots by GC-TOF/MS
##' 
##' @keywords datasets
##' @references Atsushi Fukushima et al. BMC Syst Biol 2011 5:1.
##' @author Atsushi Fukushima
NULL

