% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_data.R
\name{edge_data}
\alias{edge_data}
\title{Insert edge data attributes during edge creation}
\usage{
edge_data(...)
}
\arguments{
\item{...}{Edge data attributes provided as one or more named vectors.}
}
\description{
This helper function should be invoked to provide values for the namesake
\code{edge_data} argument, which is present in any function where edges are
created.
}
\examples{
\dontrun{
# Create a new graph and add
# a path with several edge
# data attributes
graph <-
  create_graph() \%>\%
  add_path(
    n = 3,
    type = "path",
    edge_data = edge_data(
      hour = 5,
      index = c(1, 2)))

# View the graph's internal
# edge data frame; the edge
# data attributes have
# been inserted
graph \%>\% get_edge_df()
}

}
