% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_df_as_edge_attr.R
\name{set_df_as_edge_attr}
\alias{set_df_as_edge_attr}
\title{Set a data frame as an edge attribute}
\usage{
set_df_as_edge_attr(graph, edge, df)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{edge}{the edge ID to which the data frame
will be bound as an attribute.}

\item{df}{the data frame to be bound to the
edge as an attribute.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class
\code{dgr_graph}, bind a data frame as an edge
attribute property for one given graph edge. The
data frames are stored in list columns within
a \code{df_tbl} object, itself residing within
the graph object. A \code{df_id} value is
generated and serves as a pointer to the table
row that contains the ingested data frame.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "basic",
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to")

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Create a simple data frame to add as
# an edge attribute
df <-
  data.frame(
    a = c("one", "two", "three"),
    b = c(1, 2, 3),
    stringsAsFactors = FALSE)

# Bind the data frame as an edge attribute
# to the edge with ID `1`
graph <-
  set_df_as_edge_attr(
    graph = graph,
    edge = 1,
    df = df)
}
