% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_graph_directed.R
\name{is_graph_directed}
\alias{is_graph_directed}
\title{Is the graph a directed graph?}
\usage{
is_graph_directed(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a logical value.
}
\description{
Determines whether a graph is set to be
directed or not and returns a logical value to that
effect.
}
\examples{
# Create an empty graph; by default, new graphs
# made by `create_graph()` are directed`
graph <-
  create_graph()

# Determine whether the graph is directed
is_graph_directed(graph)
#> [1] TRUE

# Use the `set_graph_undirected()` function and
# check again whether the graph is directed
graph \%>\%
  set_graph_undirected() \%>\%
  is_graph_directed()
#> [1] FALSE
}

