% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_connected_nodes.R
\name{get_all_connected_nodes}
\alias{get_all_connected_nodes}
\title{Get all nodes connected to a specified node}
\usage{
get_all_connected_nodes(graph, node)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node}{a single-length vector containing a
node ID value.}
}
\value{
a vector of node ID values.
}
\description{
With a single node serving as
the starting point get all nodes connected (i.e.,
reachable with a traversible path) to that node.
}
\examples{
# This graph, created using `create_random_graph()`
# is almost fully connected but there is an
# isolated node (`13`) with no edges
graph_1 <-
  create_random_graph(
    30, 50, set_seed = 1)

# There won't be any connected nodes to `13` so when
# specifying this isolated node with
# `get_all_connected_nodes()` will return NA
graph_1 \%>\% get_all_connected_nodes(13)
#> [1] NA

# Any other node in `graph_1` will provide a vector
# of all the nodes other than `13`
graph_1 \%>\% get_all_connected_nodes(2)
#>  [1]  1  3  4  5  6  7  8  9 10 11 12 14 15 16 17
#> [16] 18 19 20 21 22 23 24 25 26 27 28 29 30

# The following graph has two clusters of nodes
# (i.e., the graph has two connected components)
graph_2 <-
  create_graph() \%>\%
  add_path(6) \%>\%
  add_path(4)

# In `graph_2`, node `1` is in the larger of the two
# connected components
graph_2 \%>\% get_all_connected_nodes(1)
#> [1] 2 3 4 5 6

# Also in `graph_2`, node `8` is in the smaller of
# the two connected components
graph_2 \%>\% get_all_connected_nodes(8)
#> [1]  7  9 10
}

